ALTER TABLE `site_core_skins_classes` 
	ADD `class_order` INT(11) NOT NULL,
	ADD `class_note` TEXT NOT NULL;


INSERT INTO `site_core_skins_classes` (`class_name`, `class_type`, `class_alias`, `class_note`) VALUES
('delay-[value]s',		3,	'delay-[xx.yy]s','Delays the effect start of any animation class when used together.'),
('infinite',			3,	'infinite','Loops the effect of any animation class when used together.'),
('gutter-[0-50]',		3,	'gutter-[0-50]','Overwrites all vertical & horizontal grid gutters. Possible values: 0, 10, 20, 30, 40, 50.'),
('gutter-v-[0-50]',		3,	'gutter-v-[0-50]','Overwrites all vertical grid gutters. Possible values: 0, 10, 20, 30, 40, 50.'),
('gutter-h-[0-50]',		3,	'gutter-h-[0-50]','Overwrites all horizontal grid gutters. Possible values: 0, 10, 20, 30, 40, 50.'),
('module-title-small',		3,	'module-title-small','Overwrites the module title style with the widget title style.'),
('widget-title-big',		3,	'widget-title-big','Overwrites the widget title style with the module title style.'),
('module-title-center',		3,	'module-title-center','Center-aligns the module title.'),
('module-center-widgets-title',	3,	'module-center-widgets-title','Center-aligns the widget title (all widgets within <.module-body>).'),
('widget-right',		3,	'widget-right','Right-aligns the widget title & its optional header/footer content.'),
('widget-links-impact-bold',	3,	'widget-links-impact-bold','Applied to certain widget types (links & menu), overwrites the default widget style.'),
('widget-links-impact-thin',	3,	'widget-links-impact-thin','Applied to certain widget types (links & menu), overwrites the default widget style.'),
('widget-links-impact-full',	3,	'widget-links-impact-full','Applied to certain widget types (links & menu), overwrites the default widget style.'),
('widget-links-noicons',	3,	'widget-links-noicons','Applied to certain widget types (links & menu), removes the icons in front of the items.'),
('widget-icons-small',	3,	'widget-icons-small','Applied to certain widget types (share, icons, media profiles), changes the size of the icons.'),
('widget-center',		3,	'widget-center','Center-aligns all content of some compatible widgets.'),
('widget-left',			3,	'widget-left','Left-aligns all content of some compatible widgets.'),
('widget-right',		3,	'widget-right','Right-aligns all content of some compatible widgets.'),
('widget-hide-title',		3,	'widget-hide-title','Applied to a widget hides the title but keeps the space needed for it.'),
('widget-title-center',		3,	'widget-title-center','Center-aligns the widget title.'),
('widget-title-right',		3,	'widget-title-right','Right-aligns the widget title.'),
('same-height',			3,	'same-height','Applied to certain carousel widget types, forces all elements to have the same height.'),
('no-margin',			3,	'no-margin','Applied to a layout block, removes top & bottom margins for all widgets within.'),
('no-margin-bottom',		3,	'no-margin-bottom','Applied to a layout block, removes bottom margins for all widgets within.'),
('no-margin-top',		3,	'no-margin-top','Applied to a layout block, removes top margins for all widgets within.'),
('button-scroll-next-act',	3,	'.button-scroll-next-act','Applied to a layout block, adds a button to scroll automaticaly to the next section.'),

('padding-left-right',		3,	'padding-left-right','Applied to a fluid layout block, adds left & right padding.'),
('padding-top-bottom',		3,	'padding-top-bottom','Applied to a layout block, doubles the top and bottom padding.'),
('vertical-align-center',	3,	'vertical-align-center','Applied to a layout block, center-aligns vertically all widgets within the layout. <br>\r\nApplied to a compatible widget or module, center-aligns vertically all content.'),
('vertical-align-bottom',	3,	'vertical-align-bottom','Applied to a layout block, bottom-aligns vertically all widgets within the layout. <br>\r\nApplied to a compatible widget or module, bottom-aligns vertically all content.		'),
('align-self-top',		3,	'align-self-top','Applied to a layout columns, top-aligns vertically all widgets within the column.'),
('align-self-center',		3,	'align-self-center','Applied to a layout columns, center-aligns vertically all widgets within the column.'),
('align-self-bottom',		3,	'align-self-bottom','Applied to a layout columns, bottom-aligns vertically all widgets within the column.'),
('full-page',			3,	'full-page','Applied to a layout block, widget or module, forces its height to viewport height.'),
('half-page',			3	,	'half-page','Applied to a layout block, widget or module, forces its height to 1/2 of viewport height.'),
('onethird-page',		3,	'onethird-page','Applied to a layout block, widget or module, forces its height to 1/3 of viewport height.'),
('twothirds-page',		3,	'twothirds-page','Applied to a layout block, widget or module, forces its height to 2/3 of viewport height.'),
('line-spacing-double',		3,	'line-spacing-double','Applied to a paragraph or list in the rich text editor, doubles the visual space between lines.');

UPDATE `site_core_skins_classes` SET `class_order`=`class_id` WHERE `class_order`=0;